﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.FacadeContracts.Admin;
using BMS.Schedulers.DateTimeValidators;
using BMS.Utils;
using BMS.Schedulers.DateTimeValidators.CalendarValidators;
using BMS.Schedulers.DateTimeValidators.TimerValidators;

namespace BMS.Schedulers.Managers
{
    public static class Translator
    {
        private static IDateTimeValidator GetDateTimeValidator(JobCalendar calendar)
        {

            IDateTimeValidator calendarValidator = null;
            IDateTimeValidator timerValidator = null;

            switch (calendar.Occurs)
            {
                case OccurrenceInterval.Day:
                    calendarValidator = new DailyRecurs(calendar.Recurs);
                    break;

                case OccurrenceInterval.Month:
                    var runOnDay = calendar.RunOnDays[0];
                    var onDay = runOnDay.IsDayOfWeekIndexSpecified ?
                                new MonthlyRecurs.RunOnDay(runOnDay.DayIndex, runOnDay.Day) :
                                new MonthlyRecurs.RunOnDay(runOnDay.DayIndex);
                    calendarValidator = new MonthlyRecurs(calendar.Recurs, onDay);
                    break;

                case OccurrenceInterval.Week:
                    var dayOfWeeks = calendar.RunOnDays.Select(s => s.Day).ToList();
                    calendarValidator = new WeeklyRecurs(calendar.Recurs, dayOfWeeks);
                    break;
            }

            if (calendar.StartTime == calendar.EndTime)
                timerValidator = new OccursOnce(calendar.StartTime);
            else
            {
                switch (calendar.RunIntervalUnit)
                {
                    case RunInterval.Hour:
                        timerValidator = new OccursEveryHour(calendar.RunInterval, calendar.StartTime, calendar.EndTime);
                        break;
                    case RunInterval.Minute:
                        timerValidator = new OccursEveryMinute(calendar.RunInterval, calendar.StartTime, calendar.EndTime);
                        break;
                }
            }

            return calendarValidator.And(timerValidator);

        }

       public static Scheduler ToScheduler(JobCalendar calendar)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            IDateTimeValidator validator = GetDateTimeValidator(calendar);
            return new Scheduler(calendar.Id)
            {
                Name = calendar.Name,
                DateTimeValidator = validator,
                TimeZone = TimeZoneInfo.FindSystemTimeZoneById(calendar.TimeZoneId)
            };
        }
    }
}
